package org.msh.tb.bd.tbforms.dhis2.tb11;

import org.jboss.seam.annotations.Name;
import org.msh.tb.application.tasks.AsyncTask;
import org.msh.tb.bd.tbforms.dhis2.DHIS2ExportHome;

import java.util.Map;

/**
 * @author MSANTOS
 * Controller class for DHIS2 Tb 11 exportation
 */
@Name("dhis2ExportTB11Home")
public class DHIS2ExportTB11Home extends DHIS2ExportHome {

	@Override
	protected AsyncTask getTask() {
		for (AsyncTask task : taskManager.getTasks()) {
			if (task instanceof  DHIS2ExportTB11AsyncTask
					&& task.getUser().getId().equals(getUserWorkspace().getUser().getId())) {
				return task;
			}
		}

		return null;
	}

	@Override
	protected void startTask(Map<String, Object> params){
		taskManager.runTask(DHIS2ExportTB11AsyncTask.class, params);
	}

	@Override
	public String getFormId() {
		return DHIS2ExportTB11AsyncTask.DHIS2_DATA_SET_ID;
	}

	@Override
	public String getReportRole() {
		return "DHIS2_INTEGRATION_TB11";
	}
}
